/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;
import org.jetbrains.annotations.NotNull;

public class ScreenRenderer
implements BlockEntityRenderer<TileEntityScreen> {
    private final Vector3f mid = new Vector3f();
    private final Vector3i tmpi = new Vector3i();
    private final Vector3f tmpf = new Vector3f();

    public void render(TileEntityScreen te, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!te.isLoaded()) {
            return;
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        for (int i = 0; i < te.screenCount(); ++i) {
            TileEntityScreen.Screen scr = te.getScreen(i);
            if (scr.browser == null) {
                scr.createBrowser(true);
            }
            this.tmpi.set(scr.side.right);
            this.tmpi.mul(scr.size.x);
            this.tmpi.addMul(scr.side.up, scr.size.y);
            this.tmpf.set(this.tmpi);
            this.mid.set(0.5, 0.5, 0.5);
            this.mid.addMul(this.tmpf, 0.5f);
            this.tmpf.set(scr.side.left);
            this.mid.addMul(this.tmpf, 0.5f);
            this.tmpf.set(scr.side.down);
            this.mid.addMul(this.tmpf, 0.5f);
            poseStack.m_85836_();
            poseStack.m_85837_((double)this.mid.x, (double)this.mid.y, (double)this.mid.z);
            switch (scr.side) {
                case BOTTOM: {
                    poseStack.m_85845_(com.mojang.math.Vector3f.f_122223_.m_122270_(139.8f));
                    break;
                }
                case TOP: {
                    poseStack.m_85845_(com.mojang.math.Vector3f.f_122222_.m_122270_(139.8f));
                    break;
                }
                case NORTH: {
                    poseStack.m_85845_(com.mojang.math.Vector3f.f_122224_.m_122240_(180.0f));
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    poseStack.m_85845_(com.mojang.math.Vector3f.f_122224_.m_122240_(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_85845_(com.mojang.math.Vector3f.f_122225_.m_122240_(90.0f));
                }
            }
            if (scr.doTurnOnAnim) {
                long lt = System.currentTimeMillis() - scr.turnOnTime;
                float ft = (float)lt / 100.0f;
                if (ft >= 1.0f) {
                    ft = 1.0f;
                    scr.doTurnOnAnim = false;
                }
                poseStack.m_85841_(ft, ft, 1.0f);
            }
            if (!scr.rotation.isNull) {
                poseStack.m_85845_(com.mojang.math.Vector3f.f_122227_.m_122240_(scr.rotation.angle));
            }
            float sw = (float)scr.size.x * 0.5f - 0.125f;
            float sh = (float)scr.size.y * 0.5f - 0.125f;
            if (scr.rotation.isVertical) {
                float tmp = sw;
                sw = sh;
                sh = tmp;
            }
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder builder = tesselator.m_85915_();
            RenderSystem.m_69482_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157176_((int)0, (int)scr.browser.getTextureID());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            builder.m_85982_(poseStack.m_85850_().m_85861_(), -sw, -sh, 0.505f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(poseStack.m_85850_().m_85861_(), sw, -sh, 0.505f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(poseStack.m_85850_().m_85861_(), sw, sh, 0.505f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(poseStack.m_85850_().m_85861_(), -sw, sh, 0.505f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69465_();
            poseStack.m_85849_();
        }
    }

    public static class ScreenRendererProvider
    implements BlockEntityRendererProvider<TileEntityScreen> {
        @NotNull
        public BlockEntityRenderer<TileEntityScreen> m_173570_(@NotNull BlockEntityRendererProvider.Context arg) {
            return new ScreenRenderer();
        }
    }
}

